<?php
class api_transaction_model extends CI_Model {

var $transactions = 'transactions t';
	
	
	function nt_activate_customer($username,$hashed_username){
		
		$result = false;
		$dbAccess = $this->load->database('default',true);
		// die($this->prep_password($username));
		
		
		if($this->prep_password($username) == $hashed_username){
						
			$dbAccess->where('customer_username',$username);
			$dbAccess->set('customer_active', 1);
			$dbAccess->update('customers');
			
			$result = $dbAccess->affected_rows();
		}

		return $result;
	}
	

	function verify($username, $password, $partyCode,$ip,$key=false,$email=false){
	
		// $this->db->where('cu.customer_username', $username);
		// $this->db->where('lower(cu.customer_password)', strtolower($this->prep_password($password)));
		// $this->db->where('cu.customer_partycode', $partyCode);
		// $query = $this->db->get('customers cu');
		
		// $password = strtolower($this->prep_password($password));
		$password = $this->prep_password($password);
		$fixedPass = $this->config->item("passkey");
		
		if( $key == $fixedPass){
		
		$this->db->where('customer_email', $email);
		$this->db->where('customer_partycode', $partyCode);
		$query = $this->db->get('customers');
			// $query = $this->db->query("SELECT * FROM (`customers` cu)  WHERE BINARY`cu`.`customer_email` = '$email' AND `cu`.`customer_partycode` = '$partyCode'");
	}else{
			$this->db->where('customer_username', $username);
			$this->db->where('customer_password', $password);
			// $this->db->where('customer_active', 1);
			$this->db->where('customer_partycode', $partyCode);
			$query = $this->db->get('customers');
			// $query = $this->db->query("SELECT * FROM (`customers` cu)  WHERE BINARY`cu`.`customer_username` = '$username' AND cu.customer_password = '$password' AND `cu`.`customer_partycode` = '$partyCode'");
		}
				
		$count = $query->num_rows();
		if($count > 0)
		{
		
			// if(!$this->check_session_by_party_and_ip($partyCode,$ip))
				// { 
				// return 'invalid_ip';
				// }
				// else{

				//get current date and time
				$currentDateTime = $this->getCurrentDateTime();
				
				$accessCode = $this->generateAccesscode($partyCode, $username, $currentDateTime);
				$customer_id = $query->row()->customer_id;
				$email = $query->row()->customer_email;
				$sms = $query->row()->customer_sms_active;
				$mobile_number = $query->row()->customer_mobile;

				$fields = array(
					'api_customer_id' => $customer_id,
					'api_partycode' => $partyCode,
					'api_accesscode' => $accessCode,
					'api_duration'	=> 	$this->config->item("accessCode_expiry"),
					'api_session_browser' =>  $this->agent->browser().' '.$this->agent->version(),
					'api_party_ip' =>  $this->input->ip_address(),
					'api_last_activity' =>  $currentDateTime
				);
				
				// insert to db
				$this->db->set($fields);
				$this->db->insert('api_sessions');
				
				return array($accessCode,$currentDateTime, $this->config->item("accessCode_expiry"), $sms, $email,$mobile_number);
				// }

		}
		else
		{
			return 'Invalid';
		}
	

	}
	
	
	function validateAccessCode($accessCode = false){
		
		$this->db->where('api_accesscode', $accessCode);
		$this->db->order_by('api_session_id', "asc"); 
		$query = $this->db->get('api_sessions');
	
		$count = $query->num_rows();
		if($count > 0)
		{
			$result = $query->row();
			
			//get current date and time
			$currentDateTime = $this->getCurrentDateTime();
			
			$expiryTime = $result->api_duration;
			date_default_timezone_set("Asia/Manila");
			$endtime = new DateTime($result->api_time_issued);
			$endtime->modify("+" .$expiryTime ." minutes");
			$endtime = $endtime->format('Y-m-d-H:i:s');
			//check if expired 
			
			if($endtime < $currentDateTime){
				//deactivate previous access credentials
				$this->deactivateSession($accessCode, 0);
				return 'expired';
			
			}else{
			
				if($result->api_active == 0){
					return 'inactive';
				}else{
				
					//deactivate previous access credentials
					$this->deactivateSession($accessCode, 0);
					
					$token = $this->generateToken($accessCode, $currentDateTime);
					
					$partyCode = $this->get_party_code($accessCode);
					$customer_id = $this->get_customer_id($accessCode);
					
					$fields = array(
						'api_customer_id' => $customer_id,
						'api_partycode' => $partyCode,
						'api_accesscode' => $accessCode,
						'api_dynatoken' => $token,
						'api_duration'	=> 	$this->config->item("token_expiry"),
						'api_session_browser' =>  $this->agent->browser().' '.$this->agent->version(),
						'api_party_ip' =>  $this->input->ip_address(),
					);
					
					// insert to db
					$this->db->set($fields);
					$this->db->insert('api_sessions');
					
					return array($token,$currentDateTime, $this->config->item("token_expiry"));
				}
			}
			
		
		}
		else
		{
		return 'invalid';
		}
	
	}
	

	function renewToken($accessCode, $token){
	
		$this->db->where('api_accesscode', $accessCode);
		$this->db->where('api_dynatoken', $token);
		$query = $this->db->get('api_sessions');
	
		$count = $query->num_rows();
		if($count > 0)
		{
			$result = $query->row();
			
			//get current date and time
			$currentDateTime = $this->getCurrentDateTime();
			
			$expiryTime = $result->api_duration;
			date_default_timezone_set("Asia/Manila");
			$endtime = new DateTime($result->api_time_issued);
			$endtime->modify("+" .$expiryTime ." minutes");
			$endtime = $endtime->format('Y-m-d-H:i:s');
			//check if expired 
			if($endtime < $currentDateTime){
				//deactivate previous access credentials
				$this->deactivateSession($accessCode, $token);
				return 'expired';
			}else{
				if($result->api_active == 0)
				{
					return 'inactive';
				}
				else{
				
					//deactivate previous access credentials
					$this->deactivateSession($accessCode, $token);
					
					$token = $this->generateToken($accessCode, $currentDateTime);
					$partyCode = $this->get_party_code($accessCode);
					$customer_id = $this->get_customer_id($accessCode);
					
					$fields = array(
						'api_customer_id' => $customer_id,
						'api_partycode' => $partyCode,
						'api_accesscode' => $accessCode,
						'api_dynatoken' => $token,
						'api_duration'	=> 	$this->config->item("token_expiry"),
						'api_session_browser' =>  $this->agent->browser().' '.$this->agent->version(),
						'api_party_ip' =>  $this->input->ip_address(),
					);
					
					// insert to db
					$this->db->set($fields);
					$this->db->insert('api_sessions');
					
					return array($token,$currentDateTime, $this->config->item("token_expiry"));
				}
			}
			
		}else{
			return 'invalid';
		}
	
	}
	
	function deactivateSession($accessCode, $token){
	
		$this->db->where('api_accesscode',$accessCode);
		$this->db->where('api_dynatoken',$token);
		$this->db->set('api_active', 0);
		$this->db->update('api_sessions');
		return true;
	}
	
	function getCurrentDateTime(){
		$date = new DateTime(null, new DateTimeZone('Asia/Manila'));
		return $date->format('Y-m-d-H:i:s');	
		
	}
	
	function generateToken($accessCode, $time){
		return sha1($this->config->item('encryption_key'). $accessCode . $time);
	}
		
	function generateAccesscode($partyCode = false, $username=false, $time=false){
		return sha1($this->config->item('encryption_key'). $partyCode . $username . $time);
		
	}												
		
	function prep_password($password){

		return sha1($this->config->item('encryption_key').$password);
	}
	
	function add_ticket_details(){
	
		$fields = array(
			'ticket_date_entered'		=> date('Y-m-d H:i:s'),
			'ticket_session_id'			=> $this->session->userdata('csi'),
			'ticket_event_id'			=> $event_id,
			'ticket_section_id'			=> $section->section_id,
			'ticket_price_id'			=> $price_id,
			'ticket_seat'				=> $section->section_type,
			'ticket_type_id'			=> 1,
			'ticket_status'				=> 'selected'
		);
		
	}
	
	function get_party_code($accessCode){
	
		$this->db->select('api_partycode');
		$this->db->where('api_accesscode',$accessCode);
		$this->db->order_by('api_session_id', "asc"); 
		return $this->db->get('api_sessions')->row()->api_partycode;
	
	}
	
	function verify_access_token($accessCode, $token){
	
	
		$this->db->where('api_accesscode', $accessCode);
		$this->db->where('api_dynatoken', $token);
		$query = $this->db->get('api_sessions');
	
		$count = $query->num_rows();
		if($count > 0)
		{
			$result = $query->row();
			
			//get current date and time
			$currentDateTime = $this->getCurrentDateTime();
			
			$expiryTime = $result->api_duration;
			date_default_timezone_set('Asia/Manila');
			$endtime = new DateTime($result->api_time_issued);
			$endtime->modify("+" .$expiryTime ." minutes");
			$endtime = $endtime->format('Y-m-d-H:i:s');
			//check if expired 
			
			if($endtime < $currentDateTime){
				//deactivate previous access credentials
				$this->deactivateSession($accessCode, $token);
				return 'expired';
			
			}else{
				
				if($result->api_active == 0)
				{
					return 'inactive';
				}
				else{
				
					return 'valid';
					
				}
			}
			
		}else{
		
			return 'invalid';
		
		}
	
	
	
	}
	
	function verify_app_token($appCode, $token){
	
	
		$this->db->where('api_apppcode', $appCode);
		$this->db->where('api_livetoken', $token);
		$query = $this->db->get('api_sessions');
	
		$count = $query->num_rows();
		if($count > 0)
		{
			$result = $query->row();
			
			//get current date and time
			$currentDateTime = $this->getCurrentDateTime();
			
			$expiryTime = $result->api_duration;
			date_default_timezone_set('Asia/Manila');
			$endtime = new DateTime($result->api_time_issued);
			$endtime->modify("+" .$expiryTime ." minutes");
			$endtime = $endtime->format('Y-m-d-H:i:s');
			//check if expired 
			
			if($endtime < $currentDateTime){
				//deactivate previous access credentials
 				return 'expired';
			
			}else{
				
				if($result->api_gen_active == 0)
				{
					return 'inactive';
				}
				else{
				
					return 'valid';
					
				}
			}
			
		}else{
		
			return 'invalid';
		
		}
	
	
	
	}
	
	function buy_ticket($ticketDetails, $accessCode, $referrer = false, $profession=false){
	// print_r($ticketDetails);
 	$customer_id = $this->get_customer_id($accessCode);
	
	if($profession){
		$this->insert_customer_profession( $customer_id,$profession);
	}
	
	$this->db->select('section_type');
	$this->db->where('section_id', $ticketDetails[0][1]); 
	$section = $this->db->get('sections')->row();
	 
	
	//prepare trans details
	$trans_details = array(
		'transaction_date'				=> date("Y-m-d H:i:s"),
		'transaction_user_id'			=> 1,
		'transaction_receipt_number'	=> 1,
		'transaction_customer_id'		=> $customer_id,
		'transaction_branch_id'			=> 90,
		'transaction_terminal_id'		=> 1,
		'transaction_status'			=> $transaction_status,
		'transaction_referrer'			=> $referrer,
	);	
	
	//insert to transactions table
	$this->db->set($trans_details);
	$this->db->insert('transactions');
	
	$transaction_id = $this->db->insert_id();
	
	foreach($ticketDetails as $tixDetails):
	
		if($tixDetails[4] == 0 && $tixDetails[5] == 0 && $tixDetails[6] == 0 && $tixDetails[7] == 0){
		 
			$tix_details = array(
				'ticket_transaction_id'		=> $transaction_id,
				'ticket_date_entered'		=> date('Y-m-d H:i:s'),
				'ticket_session_id'			=> $accessCode,
				'ticket_event_id'			=> $tixDetails[0],
				'ticket_section_id'			=> $tixDetails[1],
				'ticket_price_id'			=> $tixDetails[2],
				'ticket_type_id'			=> $tixDetails[3],
				// 'ticket_row'				=> $tixDetails[4],
				'ticket_seat'				=> $section->section_type,
				'ticket_system_row'			=> $tixDetails[6],
				'ticket_system_col'			=> $tixDetails[7],
				'ticket_status'				=> 'selected',
				'ticket_user_id'			=> 1,
				'ticket_branch_id'			=> 90,
				'ticket_terminal_id'		=> 1

			);
			//insert to tickets table
			// $this->db->set($tix_details);
			// $this->db->insert('tickets');
			// echo $this->db->last_query();

			//update tickets table
			$this->db->set($tix_details);
			$this->db->where('ticket_session_id',$accessCode);
			$this->db->where('ticket_section_id',$tixDetails[1]);
			$this->db->where('ticket_row',$tixDetails[6]);
			$this->db->where('ticket_seat','FreeSeating');
			$this->db->where('ticket_status','selected');
			$this->db->update('tickets');

		}else{
 
			//prepare ticket details	
			 $tix_details = array(
				'ticket_transaction_id'		=> $transaction_id,
				// 'ticket_date_entered'		=> date('Y-m-d H:i:s'),
				'ticket_session_id'			=> '',
				// 'ticket_event_id'			=> $tixDetails[0],
				// 'ticket_section_id'			=> $tixDetails[1],
				'ticket_price_id'			=> $tixDetails[2],
				'ticket_type_id'			=> $tixDetails[3],
				// 'ticket_row'				=> $tixDetails[4],
				// 'ticket_seat'				=> $tixDetails[5],
				// 'ticket_system_row'			=> $tixDetails[6],
				// 'ticket_system_col'			=> $tixDetails[7],
				// 'ticket_status'				=> 'selected',
				'ticket_user_id'			=> 1,
				'ticket_branch_id'			=> 90,
				'ticket_terminal_id'		=> 1	
			);
 
	  
			//update tickets table
			$this->db->set($tix_details);
			$this->db->where('ticket_session_id',$accessCode);
			$this->db->where('ticket_section_id',$tixDetails[1]);
			$this->db->where('ticket_row',$tixDetails[6]);
			$this->db->where('ticket_seat',$tixDetails[7]);
			$this->db->where('ticket_status','selected');
			
			$this->db->update('tickets');
		 
		
		}
		
		endforeach;
		
		return array('success', $transaction_id, date('Y-m-d H:i:s'), $this->config->item("token_expiry"));
	
	}

	function get_customer_id($accessCode){
	
		$this->db->select('api_customer_id');
		$this->db->where('api_accesscode', $accessCode);
		return $this->db->get('api_sessions')->row()->api_customer_id;
	}
	
	function paid_online($transaction_id, $status = false )
	{
	    
		if(!$status){
			array('selected' );
		}
		
		// update the transactions table
		$this->db->where('transaction_id', $transaction_id);
		$this->db->update('transactions', array('transaction_status' => 'paid_online'));

		// update the status of the tickets
		$this->db->where_in('ticket_status',  $status );
		$this->db->where('ticket_transaction_id', $transaction_id);
		$this->db->update('tickets', array('ticket_status' => 'paid_online'));
		
		return true;
	}
	
	
	function get($transaction_id)
	{
		/* 
		$this->db->join('terminals te', 't.transaction_terminal_id = te.terminal_id');
		$this->db->join('branches b', 't.transaction_branch_id = b.branch_id');
		$this->db->join('users u', 't.transaction_user_id = u.user_id');
		$this->db->join('customers c', 't.transaction_customer_id = c.customer_id');
		$this->db->where('transaction_id', $transaction_id); 
		*/
		
		$sql = "SELECT *
				FROM (`transactions` t)
				JOIN `terminals` te ON `t`.`transaction_terminal_id` = `te`.`terminal_id`
				JOIN `branches` b ON `t`.`transaction_branch_id` = `b`.`branch_id`
				JOIN `users` u ON `t`.`transaction_user_id` = `u`.`user_id`
				LEFT JOIN `card_numbers` cn ON `t`.`transaction_id` = `cn`.`card_number_transaction_id`
				LEFT JOIN `customers` c ON `t`.`transaction_customer_id` = `c`.`customer_id` 
				
				WHERE `transaction_id` = '$transaction_id'";
		
		$query = $this->db->query($sql);
	
		return $query->row();		
	}
	
	function get_or($transaction_id){
	
		$this->db->select('transaction_receipt_number');
		$this->db->where('transaction_id', $transaction_id);
		$query = $this->db->get('transactions');
		return $query->row()->transaction_receipt_number;
	
	}
	
	function get_for_bcode($transaction_id)
	{
		$this->db->join('terminals te', 't.transaction_terminal_id = te.terminal_id');
		$this->db->join('branches b', 't.transaction_branch_id = b.branch_id');
		$this->db->join('users u', 't.transaction_user_id = u.user_id');
		$this->db->join('customers c', 't.transaction_customer_id = c.customer_id');
		$this->db->where('transaction_id', $transaction_id);
		$query = $this->db->get('transactions t');
	
		return $query->row();		
	}
	
	function add_barcode($transaction_id, $barcode)
	{
		// update the tickets table
		$this->db->where('transaction_id', $transaction_id);
		$this->db->update('transactions', array('transaction_barcode' => $barcode));
		
		return true;
	}
  
	function update_receipt_number($transaction_id, $receipt_number)
	{
		// update the transactions table
		$this->db->where('transaction_id', $transaction_id);
		$this->db->update('transactions', array('transaction_receipt_number' => $receipt_number));
		
		return true;
	}
	/*  
	function check_ticket_details($ticketDetails, $totalAmount){
 
 		$event_ids = array();
 		$section_ids = array();
  		$price_ids = array();
 		$unique_event_ids = array();
 		$unique_section_ids = array();
 		$used_seats = array();
 		//0-eventid 1-sectionid 2-priceid 3-tickettypeid 4-systemrow 5-systemcol 6-ticketrow 7-ticketseat  8-actualprice 9-convenience
		foreach($ticketDetails as $tix){
 		
			if(count($tix) != 9)
			//check if correct datamessage format
			foreach($tix as $key => $value) {
 				if($value == "") { return 0; }
				
				// compile event_ids
				if ($key == 0 ) {
					$event_ids[] = $value;
				}
				if ($key == 1 ) {
					$section_ids[] = $value;
				} 
				
				//force ticket_type_id condition 1
				if ($key == 3 ) { 
					if($value != 1){ return 0;} 
				}
				 
			}
 		}
			

		// identify unique elements needed for data gathering
		$unique_event_ids = array_unique($event_ids);
		$unique_section_ids = array_unique($section_ids);
		
		
		// build data using ticket details (including unique elements for ticket check) 
		//check event_id
		list($events_info,$prices_event_info, $events_ticket_type_info) = $this->get_selected_events($unique_event_ids);
		$sections_info = $this->get_selected_sections($unique_section_ids);
		$used_seats = $this->get_selected_used_section_seats($unique_section_ids);
			
	 
 		//0-eventid 1-sectionid 2-priceid 3-tickettypeid 4-systemrow 5-systemcol 6-ticketrow 7-ticketseat  8-actualprice 9-convenience
		$amount_total = 0;
		foreach($ticketDetails as $tix){ 
			$event_id = $tix[0];
			$section_id = $tix[1];
			$price_id = $tix[2];
			$ticket_type_id = $tix[3];
			$system_row = $tix[4];
			$system_col = $tix[5];
			$ticket_row = $tix[6];
			$ticket_seat = $tix[7]; 
			$actual_price = $tix[8];
			$convenience = $tix[9];
			
			// $event_id = $row->event_id;
			// $event_info[$event_id]['online_fee'] =  $row->event_internet_sales_charge;
			// $event_info[$event_id]['ek'] =  $row->events_config_ekbarcode_active;
			// $event_info[$event_id]['active'] =  $row->event_active;
		
			//check if event is valid 
 			if(isset( $events_info[$event_id]['online_active'])){ 
				if(!$events_info[$event_id]['online_active']){ return 0; }
				if($events_info[$event_id]['online_fee'] != $convenience ){ return 0; }
			}else{ return 0;}
			
 			
 			// $events_price_info[$event_id][$price_id][$section_id] = $price_amount ;
			//if ticket type id is 1
			if($ticket_type_id != 1){ return 0;} 
			
 			
			//check eventid, priceid , sectionid and amount validity	
			if(isset($prices_event_info[$event_id][$price_id][$section_id] )){ 
				$ticket_price = $prices_event_info[$event_id][$price_id][$section_id];
				//  $ticket_price = number_format($ticket_price, 2, '', '');
				if($ticket_price != $actual_price){ return 0;} 
				
				$amount_total = $amount_total + $ticket_price + $convenience;
				
			}else{ return 0;}
		
 		
			//check existence of seat in a section
			$section_type =	$sections_info[$section_id]['section_type'];
			$section_seat_config =	$sections_info[$section_id]['section_seat_config'];
			
			
			if($section_type != 'Reserved'){ 
 				if($system_row != 0 || $system_col != 0 || $ticket_row != 0 || $ticket_seat != 0){ return 0;} 
			}else{ 
 				//check seat validity and used seats
				if(!$this->validate_seat($section_type, $section_seat_config, $system_row, $system_col, $ticket_row, $ticket_seat)){ return 0;} 
				if(isset($used_seats[$system_row][$system_col][$ticket_row][$ticket_seat])){ return 0 ;}
				
			}
		  
		} 
		
		$amount_total = number_format($amount_total, 2, '', '');
		// $totalAmount = number_format($totalAmount, 2, '', '');
		// echo $amount_total . '/' . $totalAmount;
		if($amount_total != $totalAmount){ return 2;}
		
		return 1;
 
	
	}
  */
	
	 function check_ticket_details($ticketDetails, $totalAmount, $accessCode){

			 $event_ids = array();
			 $section_ids = array();
			  $price_ids = array();
			 $unique_event_ids = array();
			 $unique_section_ids = array();
			 $used_seats = array();
			 //0-eventid 1-sectionid 2-priceid 3-tickettypeid 4-systemrow 5-systemcol 6-ticketrow 7-ticketseat  8-actualprice 9-convenience
			$loop = 0;
			foreach($ticketDetails as $tix){

				if(count($tix) != 9)
				//check if correct datamessage format
				foreach($tix as $key => $value) {
					 if($value == "") { return 0; }

					// compile event_ids
					if ($key == 0 ) {
						$event_ids[] = $value;
					}
					if ($key == 1 ) {
						$section_ids[] = $value;
					}

					//force ticket_type_id condition 1
					// if ($key == 3 ) {
						// if($value != 1){ return 0;}
					// }

				}
				
				
				$ticket_type_id = $tix[3];
			 }

			// print_r($ticketDetails);
			 
			// identify unique elements needed for data gathering
			$unique_event_ids = array_unique($event_ids);
			$unique_section_ids = array_unique($section_ids);


			// build data using ticket details (including unique elements for ticket check)
			//check event_id
			list($events_info,$prices_event_info, $events_ticket_type_info) = $this->get_selected_events($unique_event_ids,$ticket_type_id);
			$sections_info = $this->get_selected_sections($unique_section_ids);
			$used_seats = $this->get_selected_used_section_seats($unique_section_ids);


			 //0-eventid 1-sectionid 2-priceid 3-tickettypeid 4-systemrow 5-systemcol 6-ticketrow 7-ticketseat  8-actualprice 9-convenience
				$amount_total = 0;
				foreach($ticketDetails as $tix){
				$event_id = $tix[0];
				$section_id = $tix[1];
				$price_id = $tix[2];
				$ticket_type_id = $tix[3];
				$system_row = $tix[4];
				$system_col = $tix[5];
				$ticket_row = $tix[6];
				$ticket_seat = $tix[7];
				$actual_price = $tix[8];
				$convenience = $tix[9];

				// $event_id = $row->event_id;
				// $event_info[$event_id]['online_fee'] = $row->event_internet_sales_charge;
				// $event_info[$event_id]['ek'] = $row->events_config_ekbarcode_active;
				// $event_info[$event_id]['active'] = $row->event_active;

				//check if event is valid
				 if(isset( $events_info[$event_id]['online_active'])){
					if(!$events_info[$event_id]['online_active']){ return 0; }
					if($events_info[$event_id]['online_fee'] != $convenience ){ return 0; }
				}else{ return 0;}


				 // $events_price_info[$event_id][$price_id][$section_id] = $price_amount ;
				//if ticket type id is 1 korewa
				// if($ticket_type_id != 1){ return 0;}


				//check eventid, priceid , sectionid and amount validity
					if(isset($prices_event_info[$event_id][$price_id][$section_id] )){
					$ticket_price = $prices_event_info[$event_id][$price_id][$section_id];
					//  $ticket_price = number_format($ticket_price, 2, '', '');
					if($ticket_price != $actual_price){  return 0;}

					$amount_total = $amount_total + $ticket_price + $convenience;

				}else{ return 0;}


				//check existence of seat in a section
				$section_type = $sections_info[$section_id]['section_type'];
				$section_seat_config = $sections_info[$section_id]['section_seat_config'];


				if($section_type != 'Reserved'){
					 if($system_row != 0 || $system_col != 0 || $ticket_row != 0 ){  
					 return 0; 
					 }elseif(($this->check_ticket_availability($event_id, $section_id)-$loop) < 1 ){ 
					 
					 
					 return 0;
					 } 
					 
					$loop++; 
					 
				}else{
					 //check seat validity and used seats
					if(!$this->validate_seat($section_type, $section_seat_config, $system_row, $system_col, $ticket_row, $ticket_seat)){ return 0;}
					
					if(isset($used_seats[$system_row][$system_col][$ticket_row][$ticket_seat])){

						if($used_seats[$system_row][$system_col][$ticket_row][$ticket_seat] == 'selected'){

							if($used_seats['session'][$system_row][$system_col][$ticket_row][$ticket_seat] != $accessCode){
								// echo $used_seats['session'][$system_row][$system_col][$ticket_row][$ticket_seat];
								// Die();
								return 0 ;
							}

						}else{
							
							return 0 ;
						
						}


					}

				}

			}

			$amount_total = number_format($amount_total, 2, '', '');
			// $totalAmount = number_format($totalAmount, 2, '', '');
			// echo $amount_total . '/' . $totalAmount;
			if($amount_total != $totalAmount){ return 2;}

			return 1;


		}

		
	 function validate_seat($section_type, $section_config, $system_row, $system_col, $ticket_row, $ticket_col) {
		$valid = false; 
		
		if ($section_type == "Reserved") {
			$check_row = "R$system_row";
			$check_col = "C$system_col";
			$ticket_seat = "$check_row|$check_col|$ticket_row|$ticket_col";
			$tmp_seat_config = unserialize($section_config);
			if(isset($tmp_seat_config[$check_row][$check_col])) {
				$tmp_seat = $tmp_seat_config[$check_row][$check_col];
				if ($tmp_seat == $ticket_seat) {
					$valid =1;
				}
			}
		}
		return $valid;
	}
	
	function get_selected_events($eventids = false,$ticket_type_id = false){
		$event_info = array();
		$event_price_info = array();
		$event_ticket_type_info = array();
		
		
		// $ticket_type_id
		$this->db->where('ticket_type_id', $ticket_type_id);
		$ticket_type = $this->db->get('ticket_types'); 
		$ticket_type = $ticket_type->row();
		if(!$ticket_type){
			return 0;
		}
		
		$discount_type = $ticket_type->ticket_type_discount_type;
		$discount = $ticket_type->ticket_type_discount;
		
		
		
		// echo '<pre>';
		// print_r($ticket_type);
		// echo '</pre>';
		
		// print_r($ticket_type);
		$this->db->select('event_id, event_ticket_types, event_internet_sales_charge, ec.events_config_ekbarcode_active, event_active');
		$this->db->join('events_config ec', 'ec.events_config_eventid = event_id');
		$this->db->where_in('event_id' , $eventids);
		$query = $this->db->get('events');
 		
	 
		$result = $query->result();
		
		
		foreach($result as $row){
		
			$event_id = $row->event_id;
			$event_info[$event_id]['online_fee'] =  $row->event_internet_sales_charge;
			$event_info[$event_id]['ek'] =  $row->events_config_ekbarcode_active;
			$event_info[$event_id]['active'] =  $row->event_active;
			$event_info[$event_id]['online_active'] = false;
			
			$ticket_types =  unserialize($row->event_ticket_types);
			
			if($event_info[$event_id]['online_fee'] != '' && $event_info[$event_id]['ek'] == 0 && $event_info[$event_id]['active'] == 1 ){
				$event_info[$event_id]['online_active'] =  true;
				foreach($ticket_types as $ticket_type){
				
				$event_ticket_type_info[$event_id][$ticket_type] = true;
				
				}
			}
		}
		
		 
  		$this->db->where_in('price_event_id' , $eventids);
		$query = $this->db->get('prices');
 		
	 
		$result = $query->result();
		
		 
		
		foreach($result as $row){
			
			$event_id = $row->price_event_id;
			$price_id = $row->price_id;
			$price_amount = $row->price_price;
			// echo $discount_type;
			// die();
			
			//korewa 
			if ($discount_type== 'Amount'): 
			$price_amount = ceil($price_amount - $discount);  
			elseif ($discount_type == 'Percentage'): 
			$price_amount = ceil($price_amount - (($price_amount * $discount)/100)); 
			endif; 

			
			$price_section_config = unserialize($row->price_sections);
			foreach($price_section_config as $section_id) {
				$event_price_info[$event_id][$price_id][$section_id] = $price_amount ;
			}
		}
		// die();
		return array($event_info, $event_price_info, $event_ticket_type_info);
	}
	
	function get_selected_sections($sectionids){
	
		$section_info = array();
		$this->db->where_in('section_id' , $sectionids);
		$query = $this->db->get('sections');
		
		foreach($query->result() as $row){
		
		$section_id = $row->section_id;
		$section_info[$section_id]['section_type'] = $row->section_type;
		$section_info[$section_id]['section_seat_config'] = $row->section_seat_config; 
		}
		
		return $section_info;
	
	}
	
/* 	function get_selected_used_section_seats($unique_section_ids){

	
		$used_seats = array();
		//'done','paid','paid_online','selected','reserved','expired','cancelled','voided','reservation_cancelled','unselected'
		$ticket_status = array('done','paid','paid_online','reserved','selected');
		
		$this->db->select('ticket_system_row, ticket_system_col, ticket_row, ticket_seat, ticket_status');
		$this->db->where_in('ticket_section_id', $unique_section_ids);  
		$this->db->where_in('ticket_status', $ticket_status);   
		$query = $this->db->get('tickets');
	 
		foreach($query->result() as $row){ 
		$used_seats[$row->ticket_system_row][$row->ticket_system_col][$row->ticket_row][$row->ticket_seat] = $row->ticket_status; 
		} 
			

		
		return $used_seats; 
	}
	
 */
	 
  function get_selected_used_section_seats($unique_section_ids){
        $used_seats = array();
		//'done','paid','paid_online','selected','reserved','expired','cancelled','voided','reservation_cancelled','unselected'
        $ticket_status = array('done','paid','paid_online','reserved','selected');

        $this->db->select('ticket_system_row, ticket_system_col, ticket_row, ticket_seat, ticket_status, ticket_session_id');
        $this->db->where_in('ticket_section_id', $unique_section_ids);
        $this->db->where_in('ticket_status', $ticket_status);
        $query = $this->db->get('tickets');

        foreach($query->result() as $row){
		$used_seats['session'][$row->ticket_system_row][$row->ticket_system_col][$row->ticket_row][$row->ticket_seat] = $row->ticket_session_id;
		$used_seats[$row->ticket_system_row][$row->ticket_system_col][$row->ticket_row][$row->ticket_seat] = $row->ticket_status;
		}
        return $used_seats;
    }
	 
	 
	function check_session_by_party_and_ip($partycode = false, $ip = false){
	
	$valid = false;
	$dbAccess = $this->load->database('default',true);

			$dbAccess->where("s.api_partycode", $partycode);
				$dbAccess->where("s.api_party_ip", $ip);
				$dbAccess->where("s.api_time_issued > ",strtotime('-24 hour'));
				$query = $dbAccess->get('api_sessions s');	
	
		if ($query->num_rows() > 0)
			{
			$valid = true;
			}
		
			
	return $valid;		
	}

/* 
	function get_customer_transactions($customer_id, $offset = false, $limit = 20)
	{
		$this->db->group_by('t.transaction_id');
		$this->db->where_in('lower(transaction_status)', array('done', 'paid_online','reserved'));
		$this->db->where('transaction_customer_id', $customer_id);
		$this->db->where('transaction_visible_online', "1");
		$this->db->join('branches b', 'b.branch_id = t.transaction_branch_id', 'left');
		$this->db->join('tickets ti', 'ti.ticket_transaction_id = t.transaction_id', 'left');
		$this->db->join('events e', 'e.event_id = ti.ticket_event_id', 'left');
		$this->db->order_by('transaction_id', 'desc');
		if ($limit) $this->db->limit($limit);
		if ($offset) $this->db->offset($offset);
		$this->db->where_in('lower(transaction_status)', array('paid_online','reserved'));
		
		$query = $this->db->get('transactions t');
		
		return $query->result();
	}
 */
	function get_customer_transactions($customer_id)
	{
		$this->db->group_by('t.transaction_id');
		$this->db->where_in('lower(transaction_status)', array('done', 'paid_online','reserved'));
		$this->db->where('transaction_customer_id', $customer_id);
		$this->db->join('branches b', 'b.branch_id = t.transaction_branch_id', 'left');
		$this->db->join('tickets ti', 'ti.ticket_transaction_id = t.transaction_id', 'left');
		$this->db->join('events e', 'e.event_id = ti.ticket_event_id', 'left');
		$this->db->order_by('transaction_id', 'desc');
		
	
		$this->db->where_in('lower(transaction_status)', array('paid_online'));
		
		$query = $this->db->get('transactions t');
		
		return $query->result();
	}

	function unselect($transaction_id)
	{
		$fields = array(
			'transaction_status'	=> 'unselected',
			'transaction_comment'	=> 'unselected transaction',
		);
		// update transactions table
		$this->db->where('transaction_id', $transaction_id);
		$this->db->update($this->transactions, $fields);
	}	
	
	function get_transaction_selected_only() {
		$sql = "
			SELECT
				t.transaction_id
			FROM transactions t
			WHERE t.transaction_status IN ('selected')
		";
		return $this->db->query($sql)->result();
	}
	

	
	function get_customer_id_by_transactionID($transactionID){
	
		$this->db->select('transaction_customer_id');
		$this->db->where('transaction_id', $transactionID);
		return $this->db->get('transactions')->row()->transaction_customer_id;
	}
	
	
	function check_ticket_availability($event_id,$section_id){
	
		$status = array('paid','done','paid_online','reserved','selected');
	  
		$this->db->select("count(*) as sold, s.section_capacity as capacity");
		$this->db->join('sections s', 's.section_id = t.ticket_section_id');
		$this->db->where('t.ticket_event_id',$event_id);
		$this->db->where('t.ticket_section_id',$section_id);
		$this->db->where_in('t.ticket_status', $status);
		$query = $this->db->get('tickets t');
		$result = $query->row();
		return $result->capacity - $result->sold;
	
	}
	
	function paid_online_override($transaction_id)
	{
 		// update the transactions table
		$this->db->where('transaction_id', $transaction_id);
		$this->db->update('transactions', array('transaction_status' => 'paid_online'));

		// update the status of the tickets
		$this->db->where('ticket_status', 'unselected');
		$this->db->where('ticket_transaction_id', $transaction_id);
		$this->db->update('tickets', array('ticket_status' => 'paid_online'));
		
		return true;
	}
	
	
	
	function countTicketsByUsername($username = false, $event_id = false){
		
	$querystring = "Select count(ti.ticket_id ) as 'count' from tickets ti
					JOIN transactions t on ti.ticket_transaction_id = t.transaction_id
					JOIN customers c on c.customer_id = t.transaction_customer_id
					where ti.ticket_status IN ('selected','done', 'paid_online') 
					and c.customer_username = '$username' 
					and ti.ticket_event_id = $event_id;";
					
		
		$query = $this->db->query($querystring);
		
		return $query->row()->count;
					
	}
	
	
	
	
	
	
	/*  
	//korewa
	function get_customer_reservations($customer_id, $offset = false, $limit = 5)
	{
		$this->db->group_by('t.transaction_id');
		$this->db->where('lower(transaction_status)', 'reserved');
		$this->db->where('transaction_customer_id', $customer_id);
		$this->db->join('branches b', 'b.branch_id = t.transaction_branch_id', 'left');
		$this->db->join('tickets ti', 'ti.ticket_transaction_id = t.transaction_id', 'left');
		$this->db->join('events e', 'e.event_id = ti.ticket_event_id', 'left');
		$this->db->order_by('transaction_id', 'desc');
		if ($limit) $this->db->limit($limit);
		if ($offset) $this->db->offset($offset);
		$query = $this->db->get('transactions t');
		
		return $query->result();
	}
	
	function get_reservation($reservation_id)
	{
		 
		$sql = "SELECT *
				FROM (`transactions` t)
				JOIN `terminals` te ON `t`.`transaction_terminal_id` = `te`.`terminal_id`
				JOIN `branches` b ON `t`.`transaction_branch_id` = `b`.`branch_id`
				JOIN `users` u ON `t`.`transaction_user_id` = `u`.`user_id`
				LEFT JOIN `card_numbers` cn ON `t`.`transaction_id` = `cn`.`card_number_transaction_id`
				LEFT JOIN `customers` c ON `t`.`transaction_customer_id` = `c`.`customer_id` 
				
				
				WHERE `transaction_id` = '$reservation_id'
				AND transaction_status = 'reserved'";
		
		$query = $this->db->query($sql);
	
		return $query->row();		
	}
	 */
	 
	 
	function insert_customer_profession($customer_id, $profession){
		
		$dbAccess = $this->load->database('default',true);
		$dbAccess->where('customer_id',$customer_id);
		$dbAccess->set('customer_notes', $profession);
		$dbAccess->update('customers');
		$result = $dbAccess->affected_rows();

	}
	
	 function check_ticket_reservation_details($ticketDetails, $totalAmount ){

			 $event_ids = array();
			 $section_ids = array();
			 $price_ids = array();
			 $unique_event_ids = array();
			 $unique_section_ids = array();
			 $used_seats = array();
			 //0-eventid 1-sectionid 2-priceid 3-tickettypeid 4-systemrow 5-systemcol 6-ticketrow 7-ticketseat  8-actualprice 9-convenience
			$loop = 0;
			
					foreach($ticketDetails as $tix){

						if(count($tix) != 9)
						//check if correct datamessage format
						foreach($tix as $key => $value) {
							 if($value == "") { return "incorrect format"; }

							// compile event_ids
							if ($key == 0 ) {
								$event_ids[] = $value;
							}
							if ($key == 1 ) {
								$section_ids[] = $value;
							}
						}
										
						$ticket_type_id = $tix[3];
					 }
					 
					// identify unique elements needed for data gathering
					$unique_event_ids = array_unique($event_ids);
					$unique_section_ids = array_unique($section_ids);

					// build data using ticket details (including unique elements for ticket check)
					//check event_id
					list($events_info,$prices_event_info, $events_ticket_type_info) = $this->get_selected_events($unique_event_ids,$ticket_type_id);
					$sections_info = $this->get_selected_sections($unique_section_ids);
					$used_seats = $this->get_selected_used_section_seats($unique_section_ids);

					 //0-eventid 1-sectionid 2-priceid 3-tickettypeid 4-systemrow 5-systemcol 6-ticketrow 7-ticketseat  8-actualprice 9-convenience
						$amount_total = 0;
						foreach($ticketDetails as $tix){
								$event_id = $tix[0];
								$section_id = $tix[1];
								$price_id = $tix[2];
								$ticket_type_id = $tix[3];
								$system_row = $tix[4];
								$system_col = $tix[5];
								$ticket_row = $tix[6];
								$ticket_seat = $tix[7];
								$actual_price = $tix[8];
								$convenience = $tix[9];

								//check if event is valid
								/*  if(isset( $events_info[$event_id]['online_active'])){
									if(!$events_info[$event_id]['online_active']){ return "inactive event"; }
									if($events_info[$event_id]['online_fee'] != $convenience ){ return "convenience charge mismatch"; }
								}else{ return "inactive event";} */

								
								if($events_info[$event_id]['online_fee'] != $convenience ){ return "convenience charge mismatch"; }
								

								//check eventid, priceid , sectionid and amount validity
									if(isset($prices_event_info[$event_id][$price_id][$section_id] )){
									$ticket_price = $prices_event_info[$event_id][$price_id][$section_id];
									//  $ticket_price = number_format($ticket_price, 2, '', '');
									// if($ticket_price != $actual_price){  return "invalid ticket price amount";}
									if($ticket_price != $actual_price){  return $ticket_price  ." | " . $actual_price;}

									$amount_total = $amount_total + $ticket_price + $convenience;

								}else{ return "ticket price mismatch";}


								//check existence of seat in a section
								$section_type = $sections_info[$section_id]['section_type'];
								$section_seat_config = $sections_info[$section_id]['section_seat_config'];


								if($section_type != 'Reserved'){
									 if($system_row != 0 || $system_col != 0 || $ticket_row != 0 ){  
									 return "free seating/standing seats should be 0 on system_row,system_col and ticket_row"; 
									 }elseif(($this->check_ticket_availability($event_id, $section_id)-$loop) < 1 ){ 
									 
									 
									 return "invalid for section capacity";
									 } 
									 
									$loop++; 
									 
								}else{
									 //check seat validity and used seats
									if(!$this->validate_seat($section_type, $section_seat_config, $system_row, $system_col, $ticket_row, $ticket_seat)){ return "invalid seat";}
									
									if(isset($used_seats[$system_row][$system_col][$ticket_row][$ticket_seat])){

										// if($used_seats[$system_row][$system_col][$ticket_row][$ticket_seat] == 'selected'){
										if($used_seats[$system_row][$system_col][$ticket_row][$ticket_seat] == 'reserved'){

											// if($used_seats['session'][$system_row][$system_col][$ticket_row][$ticket_seat] != $accessCode){
												// return "accesscode mismatch" ;
											// }
										}else{
											return "seats not reserved";
										}
									}

								}

					}
					
					if($amount_total != $totalAmount){ 
					
						return "total amount mismatch";
					}

					return 1;

		}
 
		
	function mark_as_online_payment($transaction_id,$ticketDetails){

		//prepare trans details
		$trans_details = array(
			'transaction_user_id'			=> 1,
			'transaction_receipt_number'	=> 1,
			'transaction_branch_id'			=> 90,
			'transaction_terminal_id'		=> 1,
		);	
		$this->db->where('transaction_id',$transaction_id);
		$this->db->set($trans_details);
		$this->db->update('transactions');

		foreach($ticketDetails as $tixDetails):
	
			$tix_details = array(
				'ticket_user_id'			=> 1,
				'ticket_branch_id'			=> 90,
				'ticket_terminal_id'		=> 1
			);
			
			//update tickets table
			$this->db->set($tix_details);
			$this->db->where('ticket_transaction_id',$transaction_id);
			$this->db->update('tickets');
		
		endforeach;

		return false;
	}

	
	function get_customer_id_by_accesscode($accessCode){

		$this->db->where('api_accesscode', $accessCode);
		$this->db->order_by('api_session_id', "asc"); 
		$query = $this->db->get('api_sessions');
	
		// return $this->db->last_query();
		
	
		$count = $query->num_rows();
		if($count < 1){
			return 'invalid';
		}else{
			$result = $query->row();
			//get current date and time
			
			$expiryTime = $result->api_duration;
			$endtime = new DateTime($result->api_time_issued);
			$endtime->modify("+" .$expiryTime ." minutes");
			$endtime = $endtime->format('Y-m-d-H:i:s');
			//check if expired 
			
			if($endtime < date('Y-m-d H:i:s')){
				$this->deactivateSession($accessCode, 0);
				return 'expired';
			}else{
				if($result->api_active == 0){
					return 'inactive';
				}else{
					return $result->api_customer_id;	
				}
			}
		}	
	}
	
	function get_reservations($reservation_code){
		
		
		// CORRECT FORMAT sha1( branch_id-transaction_id-transaction_month_date)
		
		$this->db->group_by('t.transaction_id');
		$this->db->where_in('lower(transaction_status)', array('done', 'paid_online','reserved'));
		$this->db->where('transaction_code', sha1($reservation_code)	);
		$this->db->where('transaction_status', 'reserved' );
		$this->db->join('branches b', 'b.branch_id = t.transaction_branch_id', 'left');
		$this->db->join('tickets ti', 'ti.ticket_transaction_id = t.transaction_id', 'left');
		$this->db->join('events e', 'e.event_id = ti.ticket_event_id', 'left');
		$this->db->order_by('transaction_id', 'desc');
		
		$query = $this->db->get('transactions t');
		
		return $query->result();
	}

	
	
	}
